/**
 * Helper: Thiết lập "bộ lọc" cho ô nhập tiền
 * Chặn phím cấm, giới hạn độ dài và giới hạn giá trị tối đa
 */
window.setupInput = function(id, maxLength = 15 , limit) {
  const el = document.getElementById(id);
  if (!el) return;

  // 1. Chặn phím cấm (e, -, +, .) ngay khi nhấn
  el.addEventListener("keydown", function(e) {
    if ([ "E", "-", "+", "."].includes(e.key)) {
      e.preventDefault();
    }
  });

  // 2. Kiểm tra dữ liệu khi nhập (Input)
  el.addEventListener("input", function() {
    // Chặn độ dài ký tự (MaxLength)
    if (this.value.length > maxLength) {
      this.value = this.value.slice(0, maxLength);
    }

    let val = this.value ;
    console.log("Input value:", this.value, "Parsed BigInt:", val);
      if (this.value.length == maxLength) {
        if (window.Toastify) {
          Toastify({ text:`Vượt quá ${limit} cho phép!`, backgroundColor: "orange" }).showToast();
        }
      }
    // Kiểm tra giới hạn Max (nếu có thuộc tính max trong HTML)
    const maxAttr = this.getAttribute("max");
    if (maxAttr) {
      const maxAllowed = BigInt(maxAttr);
      if (val > maxAllowed) {
        this.value = maxAllowed.toString();
        val = maxAllowed;
        if (window.Toastify) {
          Toastify({ text:`Vượt quá ${limit} cho phép!`, backgroundColor: "orange" }).showToast();
        }
      }
    }

    // 3. Cập nhật dòng chữ đọc số
    const display = document.getElementById(id + "_in_words");
    if (display) {
      display.textContent = val > 0n ? numberToWords(Number(val)) : "";
    }
  });
};